@extends('admin.layout.master')

@section('body')
    <div class="card">
        <div class="card-header bg-info text-white">
            <h2 class="float-left">Order Details</h2>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-5">
                    <span class="float-left"><b>Exchange ID</b></span>
                    <span class="float-right">{{ $pending_exchanges->trx }}</span>
                </div>
                <div class="col-md-2">

                </div>
                <div class="col-md-5">
                    <span class="float-left"><b>Status</b></span>
                    <span class="float-right">
                        @if ($pending_exchanges->status == 1)
                            <span class="badge badge-warning">Pending</span>
                        @elseif ($pending_exchanges->status == 2 )
                            <span class="badge badge-success">Confirm</span>
                        @elseif ($pending_exchanges->status == -2)
                            <span class="badge badge-danger">Refunded</span>
                        @elseif ($pending_exchanges->status == -1)
                                <span class="badge badge-danger">Cancel</span>
                        @endif
                    </span>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="col-md-5">
                    <span class="float-left"><b>User Name</b></span>
                    <span class="float-right">{{ $pending_exchanges->user->username }}</span>
                </div>
                <div class="col-md-2">

                </div>
                <div class="col-md-5">
                    <span class="float-left"><b>Customer Email</b></span>
                    <span class="float-right">{{ $pending_exchanges->customer_email }}</span>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="col-md-5">
                    <span class="float-left"><b>Send</b></span>
                    <span class="float-right">{{ $pending_exchanges->send_method->name }}</span>
                </div>
                <div class="col-md-2">

                </div>
                <div class="col-md-5">
                    <span class="float-left"><b>Receive</b></span>
                    <span class="float-right">{{ $pending_exchanges->receive_method->name }}</span>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="col-md-5">
                    <span class="float-left"><b>Send Amount</b></span>
                    <span class="float-right">{{ $pending_exchanges->send_amount }}</span>
                </div>
                <div class="col-md-2">

                </div>
                <div class="col-md-5">
                    <span class="float-left"><b>Receive Amount</b></span>
                    <span class="float-right">{{ $pending_exchanges->receive_amount }}</span>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="col-md-5">
                    <span class="float-left"><b>{{ $pending_exchanges->send_method->name }} Transaction No.</b></span>
                    <span class="float-right">{{ $pending_exchanges->transaction_number }}</span>
                </div>
                <div class="col-md-2">

                </div>
                <div class="col-md-5">
                    <span class="float-left"><b>{{ $pending_exchanges->receive_method->name }} Transaction No.</b></span>
                    <span class="float-right">{{ $pending_exchanges->admin_transaction_number }}</span>
                </div>
            </div>

            @if ($pending_exchanges->status == -1 )
                <hr>
                <div class="row">
                    <div class="col-md-12">
                        <h4>Reason Of Cancellation</h4>
                        <p>{{ $pending_exchanges->cancel_reason }}</p>
                    </div>
                </div>
            @elseif ($pending_exchanges->status == -2 )
                <hr>
                <div class="row">
                    <div class="col-md-12">
                        <h4>Reason Of Refund</h4>
                        <p>{{ $pending_exchanges->refund_reason }}</p>
                    </div>
                </div>
            @endif

            <br>
            <br>
            <div class="row mt-4">
                <div class="col-md-12 mb-4">
                    <h2 class="text-center">Please Send <b style="color: red">{{ $pending_exchanges->receive_amount }}</b> {{ $pending_exchanges->receive_method->name }} To  <b style="color: green">{{$pending_exchanges->customer_wallet_info}}</b></h2>
                </div>

                @if($pending_exchanges->status == 1)


                    <div class="col-md-4">
                        <a data-toggle="modal" data-target="#cancelModal" ><button class="btn btn-danger btn-block"> <i class="fa fa-edit"></i> Cancel </button></a>
                    </div>
                    <div class="col-md-4">
                        <a data-toggle="modal" data-target="#successModal" ><button class="btn btn-success btn-block"> <i class="fa fa-edit"></i> Success </button></a>
                    </div>
                    <div class="col-md-4">
                        <a data-toggle="modal" data-target="#refundModal" ><button class="btn btn-warning btn-block"> <i class="fa fa-edit"></i> Refund </button></a>
                    </div>
                @endif


                <div class="col-md-12 mt-4">
                    @include('errors.error')
                </div>
            </div>
        </div>
    </div>



    <div class="modal fade cancelModal" id="cancelModal" tabindex="-1"
         role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">

                <div class="modal-header">
                    <h3>Cancel Order</h3>
                    <button type="button" class="close" data-dismiss="modal"
                            aria-hidden="true">&times;
                    </button>
                </div>
                <form method="post" action="{{ route('cancel.exchange') }}">
                    @csrf
                    <input value="{{ $pending_exchanges->id }}" type="hidden" name="id">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="cancel_reason"><strong>Reason Of Cancellation</strong></label>
                            <textarea name="reason" class="form-control form-control-lg" rows="4"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success ">Cancel Order</button>

                        <button type="button" class=" btn btn-danger" data-dismiss="modal"
                                aria-hidden="true">Close
                        </button>
                    </div>

                </form>
            </div>
        </div>
    </div>




    <div class="modal fade successModal" id="successModal" tabindex="-1"
         role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">

                <div class="modal-header">
                    <h3>Success Order</h3>
                    <button type="button" class="close" data-dismiss="modal"
                            aria-hidden="true">&times;
                    </button>
                </div>
                <form method="post" action="{{ route('success.exchange') }}">
                    @csrf
                    <input value="{{ $pending_exchanges->id }}" type="hidden" name="id">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="cancel_reason">Transaction Number</label>
                            <input type="text" class="form-control" name="admin_transaction_number">
                        </div>
                    </div>
                    <div class="modal-footer">

                        <button type="button" class=" btn btn-danger" data-dismiss="modal"
                                aria-hidden="true">Close
                        </button>
                        <button type="submit" class="btn btn-success ">Success</button>
                    </div>

                </form>
            </div>
        </div>
    </div>



    <div class="modal fade refundModal" id="refundModal" tabindex="-1"
         role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">

                <div class="modal-header">
                    <h3>Refund Order</h3>
                    <button type="button" class="close" data-dismiss="modal"
                            aria-hidden="true">&times;
                    </button>
                </div>
                <form method="post" action="{{ route('refund.exchange') }}">
                    @csrf
                    <input value="{{ $pending_exchanges->id }}" type="hidden" name="id">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="cancel_reason"><strong>Refund Balance</strong></label>
                            <div class="input-group mb-2">
                                <input class="form-control form-control-lg" type="text" name="refund_balance" >
                                <div class="input-group-prepend">
                                    <div class="input-group-text">{{ $basic->currency }}</div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="refund_reason"><strong>Refund Reason</strong></label>
                            <textarea name="refund_reason" class="form-control form-control-lg"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success ">Refund</button>
                        <button type="button" class=" btn btn-danger" data-dismiss="modal"
                                aria-hidden="true">Close
                        </button>
                    </div>

                </form>
            </div>
        </div>
    </div>


@endsection